<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:kedu="http://www.zus.pl/2015/KED_ZLA_1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://pue.zus.pl/rd/ZUS_AZLA/2/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
	
	
   <xsl:template match="/">
		<html>
			<head>
				<title>Anulowanie ZUS ZLA (Formularz) - Zakład Ubezpieczeń Społecznych</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			</head>
			<body style="text-align: center; font-family: Arial; ">
				<xsl:call-template name="eAZLA">
					<xsl:with-param name="root" select="//wnio:TrescDokumentu"/>
				</xsl:call-template>
			</body>
		</html>
   </xsl:template>
   
	<xsl:template name="eAZLA">
		<xsl:param name="root"></xsl:param>
			<xsl:call-template name="StronaAZLA">
				<xsl:with-param name="root" select="$root"/>
			</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="StronaAZLA">
		<xsl:param name="root"></xsl:param>
		<div style="width: 880px; height: 1280px; position: relative; page-break-after: always; border: 1px solid black; margin-left: auto; margin-right: auto; text-align: left; overflow: hidden; margin-top: 15px;">
			<xsl:call-template name="TytulAZLA"/>
			<xsl:call-template name="DaneLekarzaAZLA">
				<xsl:with-param name="root" select="$root"/>
			</xsl:call-template>
			<xsl:call-template name="OswiadczenieAZLA">
				<xsl:with-param name="root" select="$root"/>
			</xsl:call-template>
			<xsl:call-template name="SeriaNumerZLA">
				<xsl:with-param name="Seria" select="$root/kedu:II/kedu:p1/kedu:p1"/>
				<xsl:with-param name="Numer" select="$root/kedu:II/kedu:p1/kedu:p2"/>
			</xsl:call-template>
			<xsl:call-template name="PowodAnulowaniaAZLA">
				<xsl:with-param name="root" select="$root"/>
			</xsl:call-template>
			<xsl:call-template name="StopkaAZLA"/>
		</div>
	</xsl:template>
	<xsl:template name="SeriaNumerZLA">
		<xsl:param name="Seria"/>
		<xsl:param name="Numer"/>
		<div style="margin-left: 53px; margin-top: 15px; clear: both;">
			<div style="margin-right: 14px">
				<div style="color:#000000; font-size:12px;">Seria i numer ZUS ZLA:</div>
				<div>
					<div style="width: 49px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white; float: left; color:#000000; font-size:18px; border-style:solid; background-color:#ffffff;">
						<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
							<xsl:value-of select="$Seria"/>
						</span>
					</div>
					<div style="width: 169px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white; float: left; margin-right: 5px;	color:#000000;font-size:18px; border-style:solid; background-color:#ffffff;">
						<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
							<xsl:value-of select="$Numer"/>
						</span>
					</div>
				</div>
			</div>
			<div style="clear: both;">
				<span/>
			</div>
		</div>
	</xsl:template>
	<!-- Statyczne elementy formularza-->
	<xsl:template name="DaneLekarzaAZLA">
		<xsl:param name="root"></xsl:param>
		<div style="width: 867px; height: 166px; margin-left: 6px; margin-top: 9px; border-style: solid; border-width: 1px; clear: both; background-color:#ffffff; background-color: #FCD2BC; border-color: #F05C31;">
			<div style="margin-top: 5px; color:#000000; font-size:12px; font-weight:bold;">DANE LEKARZA</div>
			<div style="margin-top: 8px; color:#000000; font-size:12px;">1. Nazwisko lekarza</div>
			<div style="width: 745px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;" class="SofTextInput">
				<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
					<xsl:value-of select="$root/kedu:I/kedu:p3"/>
				</span>
			</div>
			<div style="margin-top: 2px; color:#000000; font-size:12px;">2. Imię lekarza</div>
			<div style="width: 529px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;" class="SofTextInput">
				<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
					<xsl:value-of select="$root/kedu:I/kedu:p2"/>
				</span>
			</div>
			<div style="margin-top: 2px; color:#000000; font-size:12px;">3. Identyfikator lekarza</div>
			<div style="width: 168px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;" class="SofTextInput">
				<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
					<xsl:value-of select="$root/kedu:I/kedu:p1"/>
				</span>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="TytulAZLA">
		<div style="width: 865px; height: 52px; margin-left: 6px; margin-top: 28px; border-style: solid; border-width: 2px; clear: both; background-color:#ffffff; background-color: #FCD2BC;border-color: #F05C31;">
			<div style="width: 100%; height: 100%; text-align: center; line-height: 52px; color:#000000; font-size:16px; font-weight:bold;">ANULOWANIE ZAŚWIADCZENIA LEKARSKIEGO</div>
		</div>
	</xsl:template>
	<xsl:template name="OswiadczenieAZLA">
		<xsl:param name="root"></xsl:param>
			<div style="margin-left: 5px; margin-top: 20px; clear: both;">
				<div style="float:left; height: 40px; line-height: 50px; margin-right: 10px; color:#000000; font-size:14px; font-family:arial; font-weight:normal;">Oświadczam, że w dniu:</div>
				<div style="float:left; height: 40px; margin-right: 12px">
					<div style="width: 118px; color:#000000; font-size:12px;">Data (dd / mm / rrrr):</div>
					<div style="width: 193px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000;font-size:18px; border-style:solid; background-color:#ffffff;">
						<span style="padding-left:8px ; padding-top:3px; font-family: Times; font-size: medium;">
							<xsl:call-template name="formatDaty">
								<xsl:with-param name="wartosc" select="$root/kedu:II/kedu:p3"/>
							</xsl:call-template>
						</span>
						<span/>
					</div>
				</div>
				<div style="height: 50px; line-height: 50px; color:#000000; font-size:14px;	font-family:arial; font-weight:normal;">anulowane zostało zaświadczenie lekarskie o numerze:</div>
			</div>
	</xsl:template>
	<xsl:template name="PowodAnulowaniaAZLA">
		<xsl:param name="root"></xsl:param>
			<div style="margin-left: 5px; margin-top: 41px; clear: both;">
				<div style="width: 172px; float: left; height: 27px; line-height: 27px; color:#000000; font-size:14px; font-family:arial; font-weight:normal;">Uzasadnienie anulowania:</div>
				<div style="width: 695px; height: 27px; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px; border-color:#000000;">
					<span style="padding-left:5px; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
						<xsl:value-of select="$root/kedu:II/kedu:p2/kedu:p2"/>
					</span>
				</div>
			</div>
	</xsl:template>
	<xsl:template name="StopkaAZLA">
		<div style="width: 870px; height: 16px; left: 4px; top: 1223px; position: absolute; clear: both;">
			<div style="width: 400px; height: 14px; left: 459px; top: 3px; text-align: right; position: absolute; font-size:11px; font-family:verdana; color:#000000;">strona: 1/1</div>
			<div style="width: 100%; height: 1px; left: 0px; top: 1px; border-top: 1px solid black; position: absolute; ">
				<span/>
			</div>
		</div>
	</xsl:template>
	<!-- componenty sof -->
	<xsl:template name="formatDaty">
		<xsl:param name="wartosc"/>
		<xsl:if test="$wartosc != ''">
			<xsl:value-of select="substring($wartosc, 9, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
