<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:kedu="http://www.zus.pl/2015/KED_ZLA_1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://pue.zus.pl/rd/ZUS_UZLA/2/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">

	<xsl:variable name="MaxNaPierwszejStronie">14</xsl:variable>
	<xsl:variable name="MaxNaPozostalychStronach">20</xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>Unieważnienie ZUS ZLA (Formularz) - Zakład Ubezpieczeń Społecznych</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			</head>
			<body style="text-align: center; font-family: Arial; ">
				<xsl:call-template name="eUZLA">
					<xsl:with-param name="root" select="//wnio:TrescDokumentu"/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="eUZLA">
		<xsl:param name="root"></xsl:param>
				<xsl:variable name="LiczbaPowtarzajacychElementow">
					<xsl:value-of select="count($root/kedu:II/kedu:p1)"/>
				</xsl:variable>
				<xsl:variable name="LiczbaStron">
					<xsl:choose>
						<xsl:when test="$LiczbaPowtarzajacychElementow + 1 &lt;= $MaxNaPierwszejStronie">1</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="ceiling(($LiczbaPowtarzajacychElementow + 1 - $MaxNaPierwszejStronie) div $MaxNaPozostalychStronach) + 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="PierwszaStrona">
					<xsl:with-param name="root" select="$root"/>
					<xsl:with-param name="LiczbaStron" select="$LiczbaStron"/>
				</xsl:call-template>
				<xsl:call-template name="PozostaleStrony">
					<xsl:with-param name="root" select="$root"/>
					<xsl:with-param name="PrzetwarzanaStrona" select="2"/>
					<xsl:with-param name="LiczbaStron" select="$LiczbaStron"/>
				</xsl:call-template>
	</xsl:template>
	<xsl:template name="PierwszaStrona">
		<xsl:param name="root"></xsl:param>
		<xsl:param name="LiczbaStron"></xsl:param>
			<div style="width: 880px; height: 1280px; position: relative; page-break-after: always; border: 1px solid black; margin-left: auto; margin-right: auto; text-align: left; overflow: hidden; margin-top: 15px;">
				<xsl:call-template name="Tytul"/>
				<xsl:call-template name="DaneLekarza">
					<xsl:with-param name="root" select="$root"/>
				</xsl:call-template>
				<xsl:call-template name="Oswiadczenie">
					<xsl:with-param name="root" select="$root"/>
				</xsl:call-template>
				<xsl:call-template name="ZakresWezlow">
					<xsl:with-param name="root" select="$root"/>
					<xsl:with-param name="Start" select="1"/>
					<xsl:with-param name="Stop" select="$MaxNaPierwszejStronie"/>
				</xsl:call-template>
				<xsl:if test="$LiczbaStron = 1">
					<xsl:call-template name="PowodUniewaznienia">
						<xsl:with-param name="root" select="$root"/>
					</xsl:call-template>	
				</xsl:if>
				<xsl:call-template name="Stopka">
					<xsl:with-param name="NumerStrony" select="1"/>
					<xsl:with-param name="LiczbaStron" select="$LiczbaStron"/>
				</xsl:call-template>
			</div>
	</xsl:template>
	<xsl:template name="PozostaleStrony">
		<xsl:param name="root"/>
		<xsl:param name="PrzetwarzanaStrona"/>
		<xsl:param name="LiczbaStron"/>
			<xsl:if test="$PrzetwarzanaStrona &lt;= $LiczbaStron">
				<xsl:call-template name="Strona">
					<xsl:with-param name="root" select="$root"/>
					<xsl:with-param name="Numer" select="$PrzetwarzanaStrona"/>
					<xsl:with-param name="LiczbaStron" select="$LiczbaStron"/>
				</xsl:call-template>
				<xsl:call-template name="PozostaleStrony">
					<xsl:with-param name="root" select="$root"/>
					<xsl:with-param name="PrzetwarzanaStrona" select="$PrzetwarzanaStrona + 1"/>
					<xsl:with-param name="LiczbaStron" select="$LiczbaStron"/>
				</xsl:call-template>
			</xsl:if>
	</xsl:template>
	<xsl:template name="Strona">
		<xsl:param name="root"/>
		<xsl:param name="Numer"/>
		<xsl:param name="LiczbaStron"/>
			<div style="width: 880px; height: 1280px; position: relative; page-break-after: always; border: 1px solid black; margin-left: auto; margin-right: auto; text-align: left; overflow: hidden; margin-top: 15px;">
				<xsl:variable name="Begin" select="$MaxNaPierwszejStronie + (($Numer - 2) * $MaxNaPozostalychStronach) + 1"/>
				<xsl:variable name="End" select="$Begin + $MaxNaPozostalychStronach - 1"/>
				<xsl:call-template name="ZakresWezlow">
					<xsl:with-param name="root" select="$root"/>
					<xsl:with-param name="Start" select="$Begin"/>
					<xsl:with-param name="Stop" select="$End"/>
				</xsl:call-template>
				<xsl:if test="$Numer = $LiczbaStron">
					<xsl:call-template name="PowodUniewaznienia">
						<xsl:with-param name="root" select="$root"/>
					</xsl:call-template>				
				</xsl:if>
				<xsl:call-template name="Stopka">
					<xsl:with-param name="NumerStrony" select="$Numer"/>
					<xsl:with-param name="LiczbaStron" select="$LiczbaStron"/>
				</xsl:call-template>
			</div>
	</xsl:template>
	<xsl:template name="ZakresWezlow">
		<xsl:param name="root"/>
		<xsl:param name="Start"/>
		<xsl:param name="Stop"/>
		<xsl:for-each select="$root/kedu:II">
			<xsl:if test="position() &gt;= $Start and position() &lt;= $Stop">
				<xsl:call-template name="SeriaNumerZLA">
					<xsl:with-param name="Seria" select="kedu:p1"/>
					<xsl:with-param name="Numer" select="kedu:p2"/>
					<xsl:with-param name="Lp" select="position()"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="SeriaNumerZLA">
		<xsl:param name="Seria"/>
		<xsl:param name="Numer"/>
		<xsl:param name="Lp"/>
		<div style="margin-left: 53px; margin-top: 10px;">
			<div style="float:left; width:20px; line-height: 50px; margin-right: 15px float: left; margin-right: 10px; color:#000000; font-size:12px; font-family:arial; font-weight:normal;">
				<xsl:value-of select="$Lp"/>.</div>
			<div style="float:left;">
				<div style="color:#000000; font-size:12px;">Seria i numer ZUS ZLA:</div>
				<div>
					<div style="width: 49px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white; float: left;	color:#000000; font-size:18px; border-style:solid; background-color:#ffffff;">
						<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
							<xsl:value-of select="$Seria"/>
						</span>
					</div>
					<div style="width: 169px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white; margin-right: 5px; float: left;	color:#000000; font-size:18px; border-style:solid; background-color:#ffffff;">
						<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
							<xsl:value-of select="$Numer"/>
						</span>
					</div>
				</div>
			</div>
			<div style="clear: both;">
				<span/>
			</div>
		</div>
	</xsl:template>
	<!-- Statyczne elementy formularza-->
	<xsl:template name="DaneLekarza">
		<xsl:param name="root"></xsl:param>
			<div style="width: 867px; height: 166px; margin-left: 6px; margin-top: 9px; border-style: solid; border-width: 1px; clear: both; background-color:#ffffff; background-color: #FCD2BC; border-color: #F05C31;">
				<div style="margin-top: 5px; color:#000000;	font-size:12px;	font-weight:bold;">DANE LEKARZA</div>
				<div style="margin-top: 8px; color:#000000;	font-size:12px;">1. Nazwisko lekarza</div>
				<div style="width: 745px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;">
					<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
						<xsl:value-of select="$root/kedu:I/kedu:p3"/>
					</span>
				</div>
				<div style="margin-top: 2px; color:#000000;	font-size:12px;">2. Imię lekarza</div>
				<div style="width: 529px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;">
					<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
						<xsl:value-of select="$root/kedu:I/kedu:p2"/>
					</span>
				</div>
				<div style="margin-top: 2px; color:#000000;	font-size:12px;">3. Identyfikator lekarza</div>
				<div style="width: 168px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;">
					<span style="padding-left:5px ; padding-top:2px; padding-right: 5px; display: block;font-family: Times; font-size: 16px;">
						<xsl:value-of select="$root/kedu:I/kedu:p1"/>
					</span>
				</div>
			</div>
	</xsl:template>
	<xsl:template name="Tytul">
		<div style="width: 865px; height: 52px; margin-left: 6px; margin-top: 28px; border-style: solid; border-width: 2px; clear: both; background-color:#ffffff; background-color: #FCD2BC; border-color: #F05C31;">
			<div style="width: 100%; height: 100%; text-align: center; line-height: 52px; color:#000000; font-size:16px; font-weight:bold;">UNIEWAŻNIENIE DRUKÓW ZAŚWIADCZENIA LEKARSKIEGO</div>
		</div>
	</xsl:template>
	<xsl:template name="Oswiadczenie">
		<xsl:param name="root"></xsl:param>
			<div style="margin-left: 5px; margin-top: 20px; clear: both;">
				<div style="float:left; height: 40px; line-height: 50px; margin-right: 10px; color:#000000;	font-size:14px;	font-family:arial; font-weight:normal;">Oświadczam, że z dniem:</div>
				<div style="float:left; height: 40px; margin-right: 12px">
					<div style="width: 118px; color:#000000; font-size:12px;">Data (dd / mm / rrrr):</div>
					<div style="width: 193px; height: 25px; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px; border-style:solid; background-color:#ffffff;">
						<span style="padding-left:8px ; padding-top:3px; font-family: Times; font-size: medium;">
							<xsl:call-template name="formatDaty">
								<xsl:with-param name="wartosc" select="$root/kedu:III/kedu:p2"/>
							</xsl:call-template>
						</span>
						<span/>
					</div>
				</div>
				<div style="height: 50px; line-height: 50px; color:#000000;	font-size:14px;	font-family:arial; font-weight:normal;">unieważniam druki ZUS ZLA o następujących numerach:</div>
			</div>
	</xsl:template>
	<xsl:template name="PowodUniewaznienia">
		<xsl:param name="root"></xsl:param>
			<div style="margin-left: 5px; margin-top: 41px; clear: both;">
				<div style="width: 148px; float: left; height: 27px; line-height: 27px; color:#000000; font-size:14px; font-family:arial; font-weight:normal;">Przyczyna unieważnienia:</div>
				<div style="width: 720px; height: 27px; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px; border-color:#000000;">
					<span style="padding-left:5px; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
						<xsl:value-of select="$root/kedu:III/kedu:p1/kedu:p2"/>
					</span>
				</div>
			</div>
	</xsl:template>
	<xsl:template name="Stopka">
		<xsl:param name="NumerStrony"/>
		<xsl:param name="LiczbaStron"/>
		<div style="width: 870px; height: 16px; left: 4px; top: 1223px; position: absolute; ">
			<div style="width: 400px; height: 14px; left: 459px; top: 3px; text-align: right; position: absolute; color:#000000; font-size:11px; font-family:verdana;">strona: <xsl:value-of select="$NumerStrony"/>/<xsl:value-of select="$LiczbaStron"/>
			</div>
			<div style="width: 100%; height: 1px; left: 0px; top: 1px; border-top: 1px solid black; position: absolute; ">
				<span/>
			</div>
		</div>
	</xsl:template>
	<!-- componenty sof -->
	<xsl:template name="formatDaty">
		<xsl:param name="wartosc"/>
		<xsl:if test="$wartosc != ''">
			<xsl:value-of select="substring($wartosc, 9, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
